package com.jiaads.jiaadsapp.gromore;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdConstant;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.native_ad.MediationCustomNativeLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.mob.ad.self.NativeAdListener;
import com.jiaads.advista.mob.ad.self.NativeFeedsData;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;
import java.util.Collections;

public class AdvistaCustomFeedLoader extends MediationCustomNativeLoader implements AdListener {
    private static final String TAG = "AdvistaCustomFeedLoader";

    private Context context;
    private String sposId;

    private AdvistaFeedExpressAd advistaFeedExpressAd;

    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {

        if (!(context instanceof Activity)) {
            Log.e(TAG, "feedsAd load: context must be instanceof Activity");
            callLoadFail(0, "feedsAd load: context must be instanceof Activity");
            return;
        }

        this.context = context;

        getAdm();
        getExtraDataNoParse();

        ((Activity) context).runOnUiThread(() -> {
            sposId = mediationCustomServiceConfig.getADNNetworkSlotId();
            if (!TextUtils.isEmpty(sposId)) {
                if (isExpressRender()){
                    AdLoadParams params = new AdLoadParams.Builder()
                            .setSposId(sposId)
                            .setWidth(adSlot.getImgAcceptedWidth() != 0 ? adSlot.getImgAcceptedWidth() : MediationConstant.FULL_WIDTH)
                            .setHeight(adSlot.getImgAcceptedHeight() != 0 ? adSlot.getImgAcceptedHeight() : MediationConstant.AUTO_HEIGHT)
                            .setMute(adSlot.getMediationAdSlot() == null || adSlot.getMediationAdSlot().isMuted())
                            .build();
                    AdvistaSdk.getInstance().loadNativeAd((Activity) context, params, AdvistaCustomFeedLoader.this);
                }else {
                    loadSelfRenderAd(adSlot);
                }
            }
        });
    }


    @Override
    public void onLoadError(int code, String msg) {
        callLoadFail(code, msg);
    }

    @Override
    public void onShowError(int code, String msg) {
        if (advistaFeedExpressAd != null){
            advistaFeedExpressAd.callRenderFail(null, code, msg);
        }
    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        if (templateAd != null) {
            advistaFeedExpressAd = new AdvistaFeedExpressAd(context, templateAd);
            callLoadSuccess(Collections.singletonList(advistaFeedExpressAd));
        }
    }

    private void loadSelfRenderAd(AdSlot adSlot) {
        AdLoadParams params = new AdLoadParams.Builder()
                .setSposId(sposId)
                .setMute(adSlot.getMediationAdSlot() == null || adSlot.getMediationAdSlot().isMuted())
                .build();
        AdvistaSdk.getInstance().loadSelfRenderNativeAd((Activity) context, params, new NativeAdListener() {
            @Override
            public void onNativeFeedAdLoaded(NativeFeedsData nativeFeedsData) {
                AdvistaFeedNativeAd advistaFeedNativeAd = new AdvistaFeedNativeAd(context, nativeFeedsData);
                if (!TextUtils.isEmpty(nativeFeedsData.getVideoUrl())){
                    advistaFeedNativeAd.setAdImageMode(TTAdConstant.IMAGE_MODE_VIDEO);
                }else {
                    advistaFeedNativeAd.setAdImageMode(TTAdConstant.IMAGE_MODE_LARGE_IMG);
                }
                callLoadSuccess(Collections.singletonList(advistaFeedNativeAd));
            }

            @Override
            public void onLoadError(int code, String msg) {
                callLoadFail(code, msg);
            }
        });
    }

    @Override
    public void onResourceReady() {
        if (advistaFeedExpressAd != null) {
            advistaFeedExpressAd.callRenderSuccess(MediationConstant.FULL_WIDTH, MediationConstant.AUTO_HEIGHT);
        }
    }

    @Override
    public void onAdExposure() {
        if (advistaFeedExpressAd != null) {
            advistaFeedExpressAd.callAdShow();
        }
    }

    @Override
    public void onAdExposureFailed(int i, String s) {

    }

    @Override
    public void onAdClicked() {
        if (advistaFeedExpressAd != null) {
            advistaFeedExpressAd.callAdClick();
        }
    }

    @Override
    public void onAdSkipped() {

    }

    @Override
    public void onAdClosed() {

    }
}
