package com.jiaads.jiaadsapp.gromore;

import android.app.Application;
import android.content.Context;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.MediationCustomInitLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomInitConfig;
import com.jiaads.advista.sdk.AdvistaSdk;
import com.jiaads.advista.sdk.InitListener;
import java.util.Map;

public class AdvistaCustomInit extends MediationCustomInitLoader {

    private static final String TAG = "AdvistaCustomInitLoader";

    @Override
    public void initializeADN(Context context, MediationCustomInitConfig mediationCustomInitConfig, Map<String, Object> map) {
        if (!isInit()){
            AdvistaSdk.getInstance().init(mediationCustomInitConfig.getAppId(), (Application) context.getApplicationContext(), new InitListener() {
                @Override
                public void onInitSuccess() {
                    callInitSuccess();
                }

                @Override
                public void onInitFailed(int i, String s) {

                }
            });
        }
    }

    @Override
    public String getNetworkSdkVersion() {
        return AdvistaSdk.geVersion();
    }


}
