package com.jiaads.jiaadsapp.gromore;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.interstitial.MediationCustomInterstitialLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AdvistaCustomInterstitialLoader extends MediationCustomInterstitialLoader implements AdListener {

    private static final String TAG = "AdvistaCustomInterstitialLoader";
    private TemplateAd templateAd;
    private double ecpm;

    @Override
    public void showAd(Activity activity) {
        if (templateAd != null) {
            templateAd.getAdControllerProxy().showAd();
        }
    }

    @SuppressLint("LongLogTag")
    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {
        if (!(context instanceof Activity)) {
            Log.e(TAG, "interstitialAd load: context must be instanceof Activity");
            callLoadFail(0, "interstitialAd load: context must be instanceof Activity");
            return;
        }

        ((Activity) context).runOnUiThread(() -> {
            String sposId = mediationCustomServiceConfig.getADNNetworkSlotId();
            if (!TextUtils.isEmpty(sposId)) {
                AdLoadParams params = new AdLoadParams.Builder()
                        .setSposId(sposId)
                        .setMute(adSlot.getMediationAdSlot() == null || adSlot.getMediationAdSlot().isMuted())
                        .build();
                AdvistaSdk.getInstance().loadInterstitialAd((Activity) context, params, AdvistaCustomInterstitialLoader.this);
            }
        });
    }

    @Override
    public void onLoadError(int code, String msg) {
        callLoadFail(code, msg);
    }

    @Override
    public void onShowError(int code, String msg) {

    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        if (templateAd != null) {
            this.templateAd = templateAd;
        }
    }

    @Override
    public MediationConstant.AdIsReadyStatus isReadyCondition() {
        Future<MediationConstant.AdIsReadyStatus> future = ThreadUtils.runOnThreadPool(new Callable<MediationConstant.AdIsReadyStatus>() {
            @Override
            public MediationConstant.AdIsReadyStatus call() throws Exception {
                if (templateAd != null && templateAd.getAdControllerProxy().isReady()) {
                    return MediationConstant.AdIsReadyStatus.AD_IS_READY;
                } else {
                    return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
                }
            }
        });
        try {
            MediationConstant.AdIsReadyStatus result = future.get(500, TimeUnit.MILLISECONDS);//设置500毫秒的总超时，避免线程阻塞
            if (result != null) {
                return result;
            } else {
                return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
    }

    @Override
    public void onResourceReady() {
        if (templateAd != null){
            if (isClientBidding()) {
                ecpm = templateAd.getAdControllerProxy().getECPM();
                callLoadSuccess(ecpm);
            } else {
                callLoadSuccess();
            }
        }
    }

    @Override
    public void onAdExposure() {
        callInterstitialShow();
    }

    @Override
    public void onAdExposureFailed(int i, String s) {

    }

    @Override
    public void onAdClicked() {
        callInterstitialAdClick();
    }

    @Override
    public void onAdSkipped() {

    }

    @Override
    public void onAdClosed() {
        callInterstitialClosed();
    }

    public boolean isClientBidding() {
        return getBiddingType() == MediationConstant.AD_TYPE_CLIENT_BIDING;
    }
}
