package com.jiaads.jiaadsapp.gromore;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.reward.MediationCustomRewardVideoLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationRewardItem;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.RewardAdListener;
import com.jiaads.advista.mob.ad.listener.RewardInfo;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;
import java.util.Collections;
import java.util.Map;

public class AdvistaCustomRewardVideoLoader extends MediationCustomRewardVideoLoader implements RewardAdListener {

    private static final String TAG = "AdvistaCustomRewardVideoLoader";
    private TemplateAd templateAd;
    
    @Override
    public void showAd(Activity activity) {
        if (templateAd != null){
            templateAd.getAdControllerProxy().showAd();
        }
    }

    @SuppressLint("LongLogTag")
    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {

        if (!(context instanceof Activity)) {
            Log.e(TAG, "rewardVideoAd load: context must be instanceof Activity");
            callLoadFail(0, "rewardVideoAd load: context must be instanceof Activity");
            return;
        }

        ((Activity) context).runOnUiThread(() -> {
           String sposId = mediationCustomServiceConfig.getADNNetworkSlotId();
           if (!TextUtils.isEmpty(sposId)) {
               AdLoadParams params = new AdLoadParams.Builder()
                       .setSposId(sposId)
                       .setMute(adSlot.getMediationAdSlot() == null || adSlot.getMediationAdSlot().isMuted())
                       .build();
               AdvistaSdk.getInstance().loadRewardVideoAd((Activity) context, params, AdvistaCustomRewardVideoLoader.this);
           }
        });
    }

    @Override
    public void onRewardVerify(RewardInfo rewardInfo) {
        if (rewardInfo != null){
            MediationRewardItem mediationRewardItem = new MediationRewardItem() {
                @Override
                public boolean rewardVerify() {
                    return rewardInfo.isRewardValid();
                }

                @Override
                public float getAmount() {
                    return rewardInfo.getRewardAmount();
                }

                @Override
                public String getRewardName() {
                    return rewardInfo.getRewardName();
                }

                @Override
                public Map<String, Object> getCustomData() {
                    return Collections.emptyMap();
                }
            };
            callRewardVideoRewardVerify(mediationRewardItem);
        }
    }

    @Override
    public void onLoadError(int errCode, String errMsg) {
        callLoadFail(errCode, errMsg);
    }

    @Override
    public void onShowError(int errCode, String errMsg) {

    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        if (templateAd != null){
            this.templateAd = templateAd;
            if (isClientBidding()) {
                callLoadSuccess(templateAd.getAdControllerProxy().getECPM());
            } else {
                callLoadSuccess();
            }
        }
    }

    @Override
    public void onResourceReady() {
        callAdVideoCache();
    }

    @Override
    public void onAdExposure() {
        callRewardVideoAdShow();
    }

    @Override
    public void onAdExposureFailed(int code, String msg) {

    }

    @Override
    public void onAdClicked() {
        callRewardVideoAdClick();
    }

    @Override
    public void onAdSkipped() {
        callRewardVideoSkippedVideo();
    }

    @Override
    public void onAdClosed() {
        callRewardVideoAdClosed();
    }

    public boolean isClientBidding() {
        return getBiddingType() == MediationConstant.AD_TYPE_CLIENT_BIDING;
    }
}
