package com.jiaads.jiaadsapp.gromore;

import android.content.Context;
import android.view.View;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.native_ad.MediationCustomNativeAd;
import com.jiaads.advista.mob.ad.TemplateAd;

public class AdvistaFeedExpressAd extends MediationCustomNativeAd {

    private TemplateAd templateAd;

    public AdvistaFeedExpressAd(Context context, TemplateAd templateAd) {
        this.templateAd = templateAd;

        setBiddingPrice(templateAd.getAdControllerProxy().getECPM());

        setExpressAd(true);
    }

    @Override
    public View getExpressView() {
        return templateAd.getAdControllerProxy().getAdView();
    }

    @Override
    public void render() {
        if (templateAd.getAdControllerProxy().isReady()){
            callRenderSuccess(MediationConstant.FULL_WIDTH, MediationConstant.AUTO_HEIGHT);
        }
    }
}
