package com.jiaads.jiaadsapp.gromore;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.bytedance.sdk.openadsdk.TTAdConstant;
import com.bytedance.sdk.openadsdk.mediation.ad.MediationViewBinder;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.native_ad.MediationCustomNativeAd;
import com.jiaads.advista.mob.ad.self.NMPlayerView;
import com.jiaads.advista.mob.ad.self.NativeAdEventListener;
import com.jiaads.advista.mob.ad.self.NativeFeedsData;
import com.jiaads.advista.mob.ad.self.NativeVideoViewListener;
import java.util.ArrayList;
import java.util.List;

public class AdvistaFeedNativeAd extends MediationCustomNativeAd {

    private NativeFeedsData mNativeFeedsData;
    private Context mContext;

    public AdvistaFeedNativeAd(Context context, NativeFeedsData nativeFeedsData) {
        this.mContext = context;
        mNativeFeedsData = nativeFeedsData;

        setBiddingPrice(mNativeFeedsData.getECPM());

        this.setActionText(mNativeFeedsData.getCtaText());
        this.setDescription(mNativeFeedsData.getDesc());
        this.setIconUrl(mNativeFeedsData.getIconUrl());
        this.setTitle(mNativeFeedsData.getTitle());
        this.setInteractionType(TTAdConstant.INTERACTION_TYPE_LANDING_PAGE);
        this.setExpressAd(false);

        if (mNativeFeedsData.getMaterialType() == NativeFeedsData.MATERIAL_TYPE_IMAGE) {
            this.setAdImageMode(TTAdConstant.IMAGE_MODE_LARGE_IMG);
            this.setImageUrl(mNativeFeedsData.getImageUrl());
            this.setImageHeight(mNativeFeedsData.getMainImageHeight());
            this.setImageWidth(mNativeFeedsData.getMainImageWidth());
        } else if (mNativeFeedsData.getMaterialType() == NativeFeedsData.MATERIAL_TYPE_VIDEO) {
            this.setAdImageMode(TTAdConstant.IMAGE_MODE_VIDEO);
            this.setImageUrl(mNativeFeedsData.getImageUrl());
            this.setImageHeight(mNativeFeedsData.getMainImageHeight());
            this.setImageWidth(mNativeFeedsData.getMainImageWidth());
        } else {
            this.setAdImageMode(TTAdConstant.IMAGE_MODE_UNKNOWN);
        }

        NMPlayerView nmPlayerView = mNativeFeedsData.getNmApAdVideo();
        if (nmPlayerView != null) {
            mNativeFeedsData.getNmApAdVideo().setVideoViewListener(new NativeVideoViewListener() {
                @Override
                public void onVideoLoading() {

                }

                @Override
                public void onVideoReady() {

                }

                @Override
                public void onVideoStart() {
                    callVideoStart();
                }

                @Override
                public void onVideoProgress(double v) {
                    callVideoProgressUpdate(mNativeFeedsData.getNmApAdVideo().getVideoCurrentPosition(),
                            mNativeFeedsData.getNmApAdVideo().getVideoDuration());
                }

                @Override
                public void onVideoPause() {
                    callVideoPause();
                }

                @Override
                public void onVideoResume() {
                    callVideoResume();
                }

                @Override
                public void onVideoCompleted() {
                    callVideoCompleted();
                }

                @Override
                public void onVideoStop() {

                }

                @Override
                public void onVideoError(int i) {
                    callVideoError(i, "");
                }
            });
        }
    }

    @Override
    public String getVideoUrl() {
        return mNativeFeedsData.getVideoUrl();
    }

    @Override
    public View getVideoView() {
        if (mNativeFeedsData != null) {
            return mNativeFeedsData.getNmApAdVideo();
        }
        return null;
    }

    @Override
    public void registerView(@Nullable Activity activity, @Nullable ViewGroup viewGroup, @Nullable List<View> list, @Nullable List<View> list1, @Nullable List<View> list2, @Nullable MediationViewBinder mediationViewBinder) {
        super.registerView(activity, viewGroup, list, list1, list2, mediationViewBinder);

        mNativeFeedsData.registerSelfRenderViews(activity, viewGroup, (ArrayList<View>) list, new NativeAdEventListener() {
            @Override
            public void onAdExposure() {
                callAdShow();
            }

            @Override
            public void onAdExposureFailed(int i, String s) {

            }

            @Override
            public void onAdClicked() {
                callAdClick();
            }
        });
    }
}
