package com.jiaads.jiaadsapp.taku;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.anythink.core.api.ATInitMediation;
import com.anythink.core.api.MediationInitCallback;
import com.jiaads.advista.sdk.AdvistaSdk;
import com.jiaads.advista.sdk.InitListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class AdvistaInitManager extends ATInitMediation{

    private static final String TAG = "Advista";

    private volatile static AdvistaInitManager sInstance;
    private final AtomicBoolean mIsIniting;
    public static boolean isInitialized = false;

    private AdvistaInitManager() {
        mIsIniting = new AtomicBoolean(false);
    }

    public static AdvistaInitManager getInstance() {
        if (sInstance == null) {
            synchronized (AdvistaInitManager.class) {
                if (sInstance == null) sInstance = new AdvistaInitManager();
            }
        }
        return sInstance;
    }

    @Override
    public void initSDK(Context context, Map<String, Object> serviceExtras, MediationInitCallback mediationInitCallback) {
        mIsIniting.set(true);
        String app_id = ATInitMediation.getStringFromMap(serviceExtras, "app_id");
        if (TextUtils.isEmpty(app_id)) {
            Log.e(TAG, "initSDK error : appId is empty ");
            mIsIniting.set(false);
            return;
        }

        if (!(context.getApplicationContext() instanceof Application)) {
            Log.d(TAG, "initSDK error : context must be instanceof Application");
            mIsIniting.set(false);
            return;
        }

        AdvistaSdk.getInstance().init(app_id, (Application) context.getApplicationContext(), new InitListener() {
            @Override
            public void onInitSuccess() {
                mIsIniting.set(false);
                isInitialized = true;
                if (mediationInitCallback != null) {
                    mediationInitCallback.onSuccess();
                }
            }

            @Override
            public void onInitFailed(int i, String s) {
                mIsIniting.set(false);
                if (mediationInitCallback != null) {
                    mediationInitCallback.onFail("Advista initFailed errorCode : " + i + " errorMsg : " + s);
                }
            }
        });
    }

}
