package com.jiaads.jiaadsapp.taku;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.core.api.ATInitMediation;
import com.anythink.core.api.MediationInitCallback;
import com.anythink.interstitial.unitgroup.api.CustomInterstitialAdapter;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;

import java.util.Map;

public class AdvistaInterstitialAdapter extends CustomInterstitialAdapter implements AdListener {

    private static final String TAG = "Advista";
    private TemplateAd popupAd;
    private boolean isReady;
    private String mAppId;
    private String mUnitId;
    private boolean isC2SBidding = false;

    @Override
    public void show(Activity activity) {
        if (activity == null) {
            Log.e(TAG, "InterstitialAd showError : activity is null");
            return;
        }
        if (popupAd == null) {
            Log.e(TAG, "InterstitialAd showError : popupAd is null");
            return;
        }
        popupAd.getAdControllerProxy().showAd();
    }

    @SuppressLint("LongLogTag")
    @Override
    public void loadCustomNetworkAd(Context context, final Map<String, Object> serverExtra, final Map<String, Object> localExtra) {
        initRequestParams(serverExtra, localExtra);

        if (TextUtils.isEmpty(mAppId) || TextUtils.isEmpty(mUnitId)) {
            Log.e(TAG, "Advista appId or unitId is empty");
            notifyATLoadFail("", "Advista appId or unitId is empty");
            return;
        }


        if (!(context instanceof Activity)) {
            Log.e(TAG, "InterstitialAd loadCustomNetworkAd: context must be instanceof Activity");
            return;
        }

        final Context appContext = context.getApplicationContext();
        if (!AdvistaInitManager.isInitialized) {
            AdvistaInitManager.getInstance().initSDK(appContext, serverExtra, new MediationInitCallback() {
                @Override
                public void onSuccess() {
                    loadInterstitialAd((Activity) context);
                }

                @Override
                public void onFail(String errorMsg) {
                    Log.e(TAG, "onInitFailed: errorMsg = " + errorMsg);
                    if (mLoadListener != null) {
                        mLoadListener.onAdLoadError("", "AdvistaSdk initError : " + errorMsg);
                    }
                }
            });
        } else {
            loadInterstitialAd((Activity) context);
        }
    }

    private void loadInterstitialAd(Activity activity) {
        AdLoadParams params = new AdLoadParams.Builder()
                .setSposId(mUnitId)
                .setMute(true)
                .build();
        activity.runOnUiThread(() -> AdvistaSdk.getInstance().loadInterstitialAd(activity, params, AdvistaInterstitialAdapter.this));
    }

    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        isC2SBidding = true;
        loadCustomNetworkAd(context, serverExtra, localExtra);
        return true;
    }

    @Override
    public void destory() {

    }

    @Override
    public boolean isAdReady() {
        return isReady;
    }

    @Override
    public String getNetworkPlacementId() {
        return mUnitId;
    }

    @Override
    public String getNetworkSDKVersion() {
        return AdvistaSdk.geVersion();
    }

    @Override
    public String getNetworkName() {
        return "";
    }

    @Override
    public void onLoadError(int errCode, String errMsg) {
        if (mLoadListener != null) {
            mLoadListener.onAdLoadError(errCode + "", errMsg);
        }
    }

    @Override
    public void onShowError(int errCode, String errMsg) {

    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        popupAd = templateAd;
    }

    @Override
    public void onResourceReady() {
        isReady = true;
        if (isC2SBidding) {
            if (mBiddingListener != null) {
                if (popupAd != null) {
                    double price = popupAd.getAdControllerProxy().getECPM();
                    AdvistaBiddingNotice ATBiddingNotice = new AdvistaBiddingNotice(popupAd);
                    mBiddingListener.onC2SBidResult(ATBiddingResult.success(price, popupAd.getAdControllerProxy().getRequestId(), ATBiddingNotice, ATAdConst.CURRENCY.RMB_CENT));
                }
            }
        } else {
            if (mLoadListener != null) {
                mLoadListener.onAdCacheLoaded();
            }
        }
    }

    @Override
    public void onAdExposure() {
        if (mImpressListener != null) {
            mImpressListener.onInterstitialAdShow();
        }
    }

    @Override
    public void onAdExposureFailed(int code, String msg) {

    }

    @Override
    public void onAdClicked() {
        if (mImpressListener != null) {
            mImpressListener.onInterstitialAdClicked();
        }
    }

    @Override
    public void onAdSkipped() {
        if (mImpressListener != null) {
            mImpressListener.onInterstitialAdClose();
        }
    }

    @Override
    public void onAdClosed() {
        if (mImpressListener != null) {
            mImpressListener.onInterstitialAdClose();
        }
    }

    private void initRequestParams(Map<String, Object> serverExtra, Map<String, Object> localExtra) {
        mAppId = ATInitMediation.getStringFromMap(serverExtra, "app_id");
        mUnitId = ATInitMediation.getStringFromMap(serverExtra, "slot_id");
    }
}
