package com.jiaads.jiaadsapp.taku;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.core.api.ATInitMediation;
import com.anythink.core.api.MediationInitCallback;
import com.anythink.nativead.unitgroup.api.CustomNativeAd;
import com.anythink.nativead.unitgroup.api.CustomNativeAdapter;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.mob.ad.self.NativeAdListener;
import com.jiaads.advista.mob.ad.self.NativeFeedsData;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;
import java.util.Map;

public class AdvistaNativeAdapter extends CustomNativeAdapter {

    private static final String TAG = "Advista";
    private TemplateAd nativeAd;
    private CustomNativeAd mCustomAd;
    private String mAppId;
    private String mUnitId;
    private int mUnitType;
    private int mAdWidth, mAdHeight;
    private boolean isC2SBidding = false;
    private Context mContext;

    @Override
    public void loadCustomNetworkAd(Context context, final Map<String, Object> serverExtra, final Map<String, Object> localExtra) {
        if (context == null) return;

        mContext = context;

        initRequestParams(serverExtra, localExtra);

        if (TextUtils.isEmpty(mAppId) || TextUtils.isEmpty(mUnitId)) {
            Log.e(TAG, "Advista appId or unitId is empty.");
            notifyATLoadFail("", "Advista appId or unitId is empty.");
            return;
        }


        if (!(context instanceof Activity)) {
            Log.e(TAG, "NativeAd loadCustomNetworkAd: context must be instanceof Activity");
            notifyATLoadFail("", "NativeAd loadCustomNetworkAd: context must be instanceof Activity");
            return;
        }

        final Context appContext = context.getApplicationContext();
        if (!AdvistaInitManager.isInitialized) {
            AdvistaInitManager.getInstance().initSDK(appContext, serverExtra, new MediationInitCallback() {
                @Override
                public void onSuccess() {
                    loadNativeAd((Activity) context);
                }

                @Override
                public void onFail(String errorMsg) {
                    Log.e(TAG, "onInitFailed: errorMsg = " + errorMsg);
                    if (mLoadListener != null) {
                        mLoadListener.onAdLoadError("", "AdvistaSdk initError : " + errorMsg);
                    }
                }
            });
        } else {
            loadNativeAd((Activity) context);
        }
    }

    private void loadNativeAd(Activity activity) {
        switch (mUnitType) {
            case 1:
                loadSelfRenderAd(activity);
                break;
            case 0:
                loadNativeExpressAd(activity);
            default:
                loadNativeExpressAd(activity);
                break;
        }
    }

    private void loadSelfRenderAd(Activity activity) {
        NativeAdListener adListener = new NativeAdListener() {
            @Override
            public void onNativeFeedAdLoaded(NativeFeedsData nativeFeedsData) {
                if (mLoadListener != null) {
                    mCustomAd = new AdvistaSelfRenderAd(nativeFeedsData);
                    if (isC2SBidding) {
                        if (mBiddingListener != null) {
                            int ecpm = nativeFeedsData.getECPM();
                            AdvistaBiddingNotice notice = new AdvistaBiddingNotice(nativeFeedsData);
                            mBiddingListener.onC2SBiddingResultWithCache(ATBiddingResult.success(ecpm,
                                    System.currentTimeMillis() + "", notice, ATAdConst.CURRENCY.RMB_CENT), mCustomAd);
                        }
                    } else {
                        if (mLoadListener != null) {
                            mLoadListener.onAdCacheLoaded(mCustomAd);
                        }
                    }
                }
            }

            @Override
            public void onLoadError(int errCode, String errMsg) {
                if (mLoadListener != null) {
                    mLoadListener.onAdLoadError(errCode + "", errMsg);
                }
            }
        };
        activity.runOnUiThread(() -> {
            AdLoadParams params = new AdLoadParams.Builder()
                    .setSposId(mUnitId)
                    .setMute(true)
                    .build();
            AdvistaSdk.getInstance().loadSelfRenderNativeAd(activity, params, adListener);
        });
    }

    private void loadNativeExpressAd(Activity activity) {
        AdListener adListener = new AdListener() {
            @Override
            public void onLoadError(int errCode, String errMsg) {
                if (mLoadListener != null) {
                    mLoadListener.onAdLoadError(errCode + "", errMsg);
                }
            }

            @Override
            public void onShowError(int errCode, String errMsg) {

            }

            @Override
            public void onAdLoaded(TemplateAd templateAd) {
                nativeAd = templateAd;
            }

            @Override
            public void onResourceReady() {
                mCustomAd = new AdvistaNativeExpressAd(nativeAd);
                if (isC2SBidding) {
                    if (mBiddingListener != null) {
                        int ecpm = nativeAd.getAdControllerProxy().getECPM();
                        AdvistaBiddingNotice notice = new AdvistaBiddingNotice(nativeAd);
                        mBiddingListener.onC2SBiddingResultWithCache(ATBiddingResult.success(ecpm,
                                System.currentTimeMillis() + "", notice, ATAdConst.CURRENCY.RMB_CENT), mCustomAd);
                    }
                } else {
                    if (mLoadListener != null) {
                        mLoadListener.onAdCacheLoaded(mCustomAd);
                    }
                }
            }

            @Override
            public void onAdExposure() {
                if (mCustomAd != null) {
                    mCustomAd.notifyAdImpression();
                }
            }

            @Override
            public void onAdExposureFailed(int code, String msg) {

            }

            @Override
            public void onAdClicked() {
                if (mCustomAd != null) {
                    mCustomAd.notifyAdClicked();
                }
            }

            @Override
            public void onAdSkipped() {

            }

            @Override
            public void onAdClosed() {

            }
        };
        activity.runOnUiThread(() -> {
            AdLoadParams params = new AdLoadParams.Builder()
                    .setSposId(mUnitId)
                    .setWidth(mAdWidth)
                    .setHeight(mAdHeight)
                    .setMute(true)
                    .build();
            AdvistaSdk.getInstance().loadNativeAd(activity, params, adListener);
        });
    }

    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        isC2SBidding = true;
        loadCustomNetworkAd(context, serverExtra, localExtra);
        return true;
    }


    @Override
    public void destory() {
        if (nativeAd != null){
            nativeAd.getAdControllerProxy().destroyAd();
        }
    }

    @Override
    public String getNetworkPlacementId() {
        return mUnitId;
    }

    @Override
    public String getNetworkSDKVersion() {
        return AdvistaSdk.geVersion();
    }

    @Override
    public String getNetworkName() {
        return "";
    }


    private void initRequestParams(Map<String, Object> serverExtra, Map<String, Object> localExtra) {
        mAppId = ATInitMediation.getStringFromMap(serverExtra, "app_id");
        mUnitId = ATInitMediation.getStringFromMap(serverExtra, "slot_id");
        mUnitType = ATInitMediation.getIntFromMap(serverExtra, "unit_type");

        // 获取像素值并转换为 dp
        mAdWidth = convertPixelsToDp(ATInitMediation.getIntFromMap(localExtra, ATAdConst.KEY.AD_WIDTH, ViewGroup.LayoutParams.MATCH_PARENT));
        mAdHeight = convertPixelsToDp(ATInitMediation.getIntFromMap(localExtra, ATAdConst.KEY.AD_HEIGHT, ViewGroup.LayoutParams.WRAP_CONTENT));

        Log.e(TAG, "initRequestParams: mAppId = " + mAppId + " mUnitId = " + mUnitId + " mUnitType = " + mUnitType + " mAdWidth = " + mAdWidth + " mAdHeight = " + mAdHeight);
    }

    private int convertPixelsToDp(int pixels) {
        if (pixels <= 0) {
            return pixels;
        }
        return Math.round(pixels / mContext.getResources().getDisplayMetrics().density);
    }

}
