package com.jiaads.jiaadsapp.taku;

import android.util.Log;
import android.view.View;
import com.anythink.nativead.unitgroup.api.CustomNativeAd;
import com.jiaads.advista.mob.ad.TemplateAd;

public class AdvistaNativeExpressAd extends CustomNativeAd {
    private static final String TAG = "Advista";

    private View adView;
    private TemplateAd templateAd;

    public AdvistaNativeExpressAd(TemplateAd templateAd) {
        this.adView = templateAd.getAdControllerProxy().getAdView();
        this.templateAd = templateAd;
    }

    @Override
    public boolean isNativeExpress() {
        return true;
    }

    @Override
    public View getAdMediaView(Object... object) {
        if (adView == null) {
            Log.e(TAG, "NativeExpress Ad has been destroyed");
            return null;
        }
        notifyAdImpression();
        return adView;
    }


    @Override
    public void destroy() {
        super.destroy();
        if (templateAd != null){
            templateAd.getAdControllerProxy().destroyAd();
        }
    }
}
