package com.jiaads.jiaadsapp.taku;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.core.api.ATInitMediation;
import com.anythink.core.api.MediationInitCallback;
import com.anythink.rewardvideo.unitgroup.api.CustomRewardVideoAdapter;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.RewardAdListener;
import com.jiaads.advista.mob.ad.listener.RewardInfo;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;

import java.util.HashMap;
import java.util.Map;

public class AdvistaRewardedVideoAdapter extends CustomRewardVideoAdapter implements RewardAdListener {
    private static final String TAG = "Advista";
    private String mAppId;
    private String mUnitId;
    private String mExtraInfo;
    private TemplateAd rewardVideoAd;
    boolean isC2SBidding = false;
    private Map<String, Object> extraMap;

    @Override
    public void show(Activity activity) {
        if (activity == null) {
            Log.e(TAG, "RewardedVideoAd showError : activity is null");
            return;
        }
        if (rewardVideoAd == null) {
            Log.e(TAG, "RewardedVideoAd showError : rewardedVideoAd is null");
            return;
        }
        rewardVideoAd.getAdControllerProxy().showAd();
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra) {
        initRequestParams(serverExtra, localExtra);

        if (TextUtils.isEmpty(mAppId) || TextUtils.isEmpty(mUnitId)) {
            Log.e(TAG, "Advista appId or unitId is empty.");
            notifyATLoadFail("", "Advista appId or unitId is empty.");
            return;
        }

        if (!(context instanceof Activity)) {
            Log.e(TAG, "RewardedVideoAd loadCustomNetworkAd: context must be instanceof Activity");
            notifyATLoadFail("", "Advista RewardedVideoAd loadCustomNetworkAd: context must be instanceof Activity.");
            return;
        }

        final Context appContext = context.getApplicationContext();
        if (!AdvistaInitManager.isInitialized){
            AdvistaInitManager.getInstance().initSDK(appContext, serverExtra, new MediationInitCallback() {
                @Override
                public void onSuccess() {
                    loadRewardVideoAd((Activity) context);
                }

                @Override
                public void onFail(String errorMsg) {
                    Log.e(TAG, "onInitFailed: errorMsg = " + errorMsg);
                    if (mLoadListener != null) {
                        mLoadListener.onAdLoadError("", "AdvistaSdk initError : " + errorMsg);
                    }
                }
            });
        }else {
            loadRewardVideoAd((Activity) context);
        }
    }


    @Override
    public void destory() {

    }

    @Override
    public boolean isAdReady() {
        Log.d(TAG, "isAdReady: " + rewardVideoAd.getAdControllerProxy().isReady());
       if (rewardVideoAd != null){
           return rewardVideoAd.getAdControllerProxy().isReady();
       }
       return false;
    }

    @Override
    public String getNetworkPlacementId() {
        return mUnitId;
    }

    @Override
    public String getNetworkSDKVersion() {
        return AdvistaSdk.geVersion();
    }

    @Override
    public String getNetworkName() {
        return "";
    }

    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        isC2SBidding = true;
        loadCustomNetworkAd(context, serverExtra, localExtra);
        return true;
    }

    private void initRequestParams(Map<String, Object> serverExtra, Map<String, Object> localExtra) {
        mAppId = ATInitMediation.getStringFromMap(serverExtra, "app_id");
        mUnitId = ATInitMediation.getStringFromMap(serverExtra, "slot_id");
        mExtraInfo = ATInitMediation.getStringFromMap(serverExtra, "extra_info");

    }

    private void loadRewardVideoAd(Activity activity){
        AdLoadParams params = new AdLoadParams.Builder()
                .setSposId(mUnitId)
                .setMute(true)
                .setExtraInfo(mExtraInfo)
                .build();
        activity.runOnUiThread(() -> AdvistaSdk.getInstance().loadRewardVideoAd(activity, params,this));
    }

    @Override
    public void onLoadError(int code, String msg) {
        notifyATLoadFail(code + "",msg);
    }

    @Override
    public void onShowError(int i, String s) {

    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        rewardVideoAd = templateAd;
    }

    @Override
    public void onResourceReady() {
        if (isC2SBidding){
            if (mBiddingListener != null){
                if (rewardVideoAd != null){
                    double price = rewardVideoAd.getAdControllerProxy().getECPM();
                    AdvistaBiddingNotice notice = new AdvistaBiddingNotice(rewardVideoAd);
                    mBiddingListener.onC2SBidResult(ATBiddingResult.success(price, rewardVideoAd.getAdControllerProxy().getRequestId(), notice, ATAdConst.CURRENCY.RMB_CENT));
                }
            }
        }else {
            if (mLoadListener != null){
                mLoadListener.onAdCacheLoaded();
            }
        }
    }

    @Override
    public void onAdExposure() {
        if (mImpressionListener != null){
            mImpressionListener.onRewardedVideoAdPlayStart();
        }
    }

    @Override
    public void onAdExposureFailed(int i, String s) {

    }

    @Override
    public void onAdClicked() {
        if (mImpressionListener != null){
            mImpressionListener.onRewardedVideoAdPlayClicked();
        }
    }

    @Override
    public void onAdSkipped() {

    }

    @Override
    public void onAdClosed() {
        if (mImpressionListener != null){
            mImpressionListener.onRewardedVideoAdClosed();
        }
    }

    @Override
    public void onRewardVerify(RewardInfo rewardInfo) {
        if (extraMap == null){
            extraMap = new HashMap<>();
            extraMap.put("gdt_trans_id",rewardInfo.getTransId());
        }
        if (mImpressionListener != null){
            if (rewardInfo.isRewardValid()){
                mImpressionListener.onReward();
            }else {
                mImpressionListener.onRewardFailed();
            }
        }
    }

    @Override
    public Map<String, Object> getNetworkInfoMap() {
        return extraMap;
    }
}
