package com.jiaads.jiaadsapp.taku;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import com.anythink.nativead.api.ATNativePrepareInfo;
import com.anythink.nativead.unitgroup.api.CustomNativeAd;
import com.jiaads.advista.mob.ad.self.NMPlayerView;
import com.jiaads.advista.mob.ad.self.NativeAdEventListener;
import com.jiaads.advista.mob.ad.self.NativeFeedsData;
import com.jiaads.advista.mob.ad.self.NativeVideoViewListener;
import java.util.ArrayList;

public class AdvistaSelfRenderAd extends CustomNativeAd {
    private static final String TAG = "AdvistaSelfRenderAd";
    private NativeFeedsData mData;

    private NMPlayerView nmPlayerView;

    public AdvistaSelfRenderAd(NativeFeedsData data) {
        mData = data;
    }

    @Override
    public double getAppPrice() {
        return mData.getECPM();
    }

    @Override
    public boolean isNativeExpress() {
        return false;
    }

    @Override
    public View getAdMediaView(Object... object) {
        if (mData.getNmApAdVideo() != null) {
            nmPlayerView = mData.getNmApAdVideo();
            nmPlayerView.setVideoViewListener(new NativeVideoViewListener() {
                @Override
                public void onVideoLoading() {

                }

                @Override
                public void onVideoReady() {

                }

                @Override
                public void onVideoStart() {
                    notifyAdVideoStart();
                }

                @Override
                public void onVideoProgress(double progress) {
                    notifyAdVideoPlayProgress((int) progress);
                }

                @Override
                public void onVideoPause() {

                }

                @Override
                public void onVideoResume() {

                }

                @Override
                public void onVideoCompleted() {
                    notifyAdVideoEnd();
                }

                @Override
                public void onVideoStop() {

                }

                @Override
                public void onVideoError(int i) {
                    notifyAdVideoVideoPlayFail(i + "", "");
                }
            });
            return nmPlayerView;
        } else {
            return null;
        }
    }

    @Override
    public String getTitle() {
        return mData.getTitle();
    }

    @Override
    public String getDescriptionText() {
        return mData.getDesc();
    }

    @Override
    public String getMainImageUrl() {
        return mData.getImageUrl();
    }

    @Override
    public String getIconImageUrl() {
        return mData.getIconUrl();
    }

    @Override
    public String getCallToActionText() {
        return mData.getCtaText();
    }


    @Override
    public void prepare(View view, ATNativePrepareInfo nativePrepareInfo) {
        if (view != null && nativePrepareInfo != null) {
            ArrayList<View> clickViews = (ArrayList<View>) nativePrepareInfo.getClickViewList();
            if (clickViews == null) {
                Log.e(TAG, "prepare: clickViews == null");
            }
            mData.registerSelfRenderViews((Activity) view.getContext(), view, clickViews, new NativeAdEventListener() {
                @Override
                public void onAdExposure() {
                    Log.e(TAG, "onAdExposure: ");
                    notifyAdImpression();
                }

                @Override
                public void onAdExposureFailed(int i, String s) {

                }

                @Override
                public void onAdClicked() {
                    notifyAdClicked();
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void resumeVideo() {
        if (mData.getNmApAdVideo() != null) {
            mData.getNmApAdVideo().resumeVideo();
        }
    }

    @Override
    public void pauseVideo() {
        if (mData.getNmApAdVideo() != null) {
            mData.getNmApAdVideo().pauseVideo();
        }
    }

    @Override
    public void setVideoMute(boolean isMute) {
        if (mData.getNmApAdVideo() != null) {
            mData.getNmApAdVideo().setVideoMute(isMute);
        }
    }

    @Override
    public double getVideoProgress() {
        if (mData.getNmApAdVideo() != null) {
            return ((float) mData.getNmApAdVideo().getVideoCurrentPosition() /
                    mData.getNmApAdVideo().getVideoDuration()) * 100;
        }
        return 0;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (mData != null) {
            mData.destroy();
        }
    }
}
