package com.jiaads.jiaadsapp.taku;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.core.api.ATInitMediation;
import com.anythink.core.api.MediationInitCallback;
import com.anythink.splashad.unitgroup.api.CustomSplashAdapter;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;

import java.util.Map;

public class AdvistaSplashAdapter extends CustomSplashAdapter implements AdListener {
    private static final String TAG = "Advista";
    private String mAppId;
    private String mUnitId;
    private boolean isReady;
    private TemplateAd splashAd;
    boolean isC2SBidding = false;

    @Override
    public void show(Activity activity, ViewGroup viewGroup) {
        if (activity == null) {
            Log.e(TAG, "SplashAd showError : activity is null");
            return;
        }
        if (viewGroup == null) {
            Log.e(TAG, "SplashAd showError : viewGroup is null");
            return;
        }
        if (splashAd == null) {
            Log.e(TAG, "SplashAd showError : splashAd is null");
            return;
        }
        splashAd.getAdControllerProxy().showAd(viewGroup);
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra) {
        initRequestParams(serverExtra, localExtra);

        if (TextUtils.isEmpty(mAppId) || TextUtils.isEmpty(mUnitId)) {
            Log.e(TAG, "Advista appId or unitId is empty.");
            notifyATLoadFail("", "Advista appId or unitId is empty.");
            return;
        }

        if (!(context instanceof Activity)) {
            Log.e(TAG, "SplashAd loadCustomNetworkAd: context must be instanceof Activity");
            notifyATLoadFail("", "Advista SplashAd loadCustomNetworkAd: context must be instanceof Activity.");
            return;
        }


        final Context appContext = context.getApplicationContext();
        if (!AdvistaInitManager.isInitialized) {
            AdvistaInitManager.getInstance().initSDK(appContext, serverExtra, new MediationInitCallback() {
                @Override
                public void onSuccess() {
                    loadSplashAd((Activity) context);
                }

                @Override
                public void onFail(String errorMsg) {
                    Log.e(TAG, "onInitFailed: errorMsg = " + errorMsg);
                    if (mLoadListener != null) {
                        mLoadListener.onAdLoadError("", "AdvistaSdk initError : " + errorMsg);
                    }
                }
            });
        } else {
            loadSplashAd((Activity) context);
        }
    }

    private void loadSplashAd(Activity activity) {
        AdLoadParams params = new AdLoadParams.Builder()
                .setSposId(mUnitId)
                .setMute(true)
                .build();
        activity.runOnUiThread(() -> AdvistaSdk.getInstance().loadSplashAd(activity, params, AdvistaSplashAdapter.this));
    }

    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        isC2SBidding = true;
        loadCustomNetworkAd(context, serverExtra, localExtra);
        return true;
    }

    @Override
    public void destory() {

    }


    @Override
    public boolean isAdReady() {
        return isReady;
    }

    @Override
    public String getNetworkPlacementId() {
        return mUnitId;
    }

    @Override
    public String getNetworkSDKVersion() {
        return AdvistaSdk.geVersion();
    }

    @Override
    public String getNetworkName() {
        return "";
    }

    private void initRequestParams(Map<String, Object> serverExtra, Map<String, Object> localExtra) {
        mAppId = ATInitMediation.getStringFromMap(serverExtra, "app_id");
        mUnitId = ATInitMediation.getStringFromMap(serverExtra, "slot_id");

        isReady = false;
    }

    @Override
    public void onLoadError(int errCode, String errMsg) {
        Log.e(TAG, "SplashAd onLoadError: errorCode : " + errCode + " errorMsg : " + errMsg);
        if (mLoadListener != null) {
            mLoadListener.onAdLoadError(errCode + "", errMsg);
        }
    }

    @Override
    public void onShowError(int errCode, String errMsg) {
        Log.e(TAG, "SplashAd onShowError: errorCode : " + errCode + " errorMsg : " + errMsg);
    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        splashAd = templateAd;
        if (splashAd != null){
            isReady = true;
            if (isC2SBidding) {
                if (mBiddingListener != null) {
                    double price = splashAd.getAdControllerProxy().getECPM();
                    AdvistaBiddingNotice advistaBiddingNotice = new AdvistaBiddingNotice(splashAd);
                    mBiddingListener.onC2SBidResult(ATBiddingResult.success(price, splashAd.getAdControllerProxy().getRequestId(), advistaBiddingNotice, ATAdConst.CURRENCY.RMB_CENT));
                }
            } else {
                if (mLoadListener != null) {
                    mLoadListener.onAdCacheLoaded();
                }
            }
        }else {
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("0","Advista no Ad");
            }
        }
    }

    @Override
    public void onResourceReady() {

    }

    @Override
    public void onAdExposure() {
        if (mImpressionListener != null) {
            mImpressionListener.onSplashAdShow();
        }
    }

    @Override
    public void onAdExposureFailed(int code, String msg) {

    }

    @Override
    public void onAdClicked() {
        if (mImpressionListener != null) {
            mImpressionListener.onSplashAdClicked();
        }
    }

    @Override
    public void onAdSkipped() {
        if (mImpressionListener != null) {
            mImpressionListener.onSplashAdDismiss();
        }
    }

    @Override
    public void onAdClosed() {
        if (mImpressionListener != null) {
            mImpressionListener.onSplashAdDismiss();
        }
    }
}
