package com.jiaads.jiaadsapp.tobid;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.ViewGroup;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.mob.ad.self.NativeAdListener;
import com.jiaads.advista.mob.ad.self.NativeFeedsData;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;
import com.windmill.sdk.WMConstants;
import com.windmill.sdk.WindMillError;
import com.windmill.sdk.base.WMAdapterError;
import com.windmill.sdk.custom.WMCustomNativeAdapter;
import com.windmill.sdk.models.BidPrice;
import com.windmill.sdk.natives.WMNativeAdData;
import org.json.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AdvistaCustomNativeAdapter extends WMCustomNativeAdapter {

    private static final String TAG = "AdvistaCustomNativeAdapter";
    private TemplateAd mNativeAd;
    private NativeFeedsData mNativeFeedsData;
    private WMNativeAdData mWMNativeAdData;
    private boolean isReady = false;
    private boolean isExpressAd = true;

    private int width;
    private int height;

    @SuppressLint("LongLogTag")
    @Override
    public void loadAd(Context context, Map<String, Object> localExtra, Map<String, Object> serverExtra) {
        try {
            if (!(context instanceof Activity)) {
                callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), "context must instanceof Activity"));
                return;
            }

            isReady = false;

            Object widthObj = localExtra.get(WMConstants.AD_WIDTH);
            if (widthObj instanceof Integer) {
                width = (Integer) widthObj;
            } else {
                width = ViewGroup.LayoutParams.MATCH_PARENT;
            }

            Object heightObj = localExtra.get(WMConstants.AD_HEIGHT);
            if (heightObj instanceof Integer) {
                height = (Integer) heightObj;
            } else {
                height = ViewGroup.LayoutParams.WRAP_CONTENT;
            }

            String placementCustomInfo = (String) serverExtra.get(WMConstants.CUSTOM_INFO);

            JSONObject object = new JSONObject(placementCustomInfo);

            String codeId = (String) serverExtra.get(WMConstants.PLACEMENT_ID);

            Log.d(TAG, "loadAd:" + codeId);

            isExpressAd = object.optBoolean("isExpressAd");
            if (!isExpressAd) {
                loadExpressAd(context, codeId);
            } else {
                loadSelfRenderAd(context, codeId);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isReady() {
        return isReady;
    }

    @Override
    public void destroyAd() {
        if (mNativeAd != null) {
            mNativeAd.getAdControllerProxy().destroyAd();
        }
        if (mNativeFeedsData != null) {
            mNativeFeedsData.destroy();
        }
    }

    @Override
    public List<WMNativeAdData> getNativeAdDataList() {
        if (mNativeAd != null) {
            return Collections.singletonList(mWMNativeAdData);
        }
        return null;
    }

    private void loadExpressAd(Context context, String codeId) {
        AdLoadParams params = new AdLoadParams.Builder()
                .setSposId(codeId)
                .setMute(true)
                .setLoadTimeOut(5000)
                .setWidth(width)
                .setHeight(height)
                .build();
        AdvistaSdk.getInstance().loadNativeAd((Activity) context, params, new AdListener() {
            @Override
            public void onLoadError(int code, String msg) {
                callLoadFail(new WMAdapterError(code, msg));
            }

            @Override
            public void onShowError(int code, String msg) {
                if (mWMNativeAdData != null) {
                    callNativeAdShowError(mWMNativeAdData, new WMAdapterError(code, msg));
                }
            }

            @Override
            public void onAdLoaded(TemplateAd templateAd) {
                if (templateAd != null) {
                    mNativeAd = templateAd;
                    mWMNativeAdData = new AdvistaNativeAdData(templateAd);
                }
            }

            @Override
            public void onResourceReady() {
                isReady = true;
                if (getBiddingType() == WMConstants.AD_TYPE_CLIENT_BIDING) {
                    callLoadBiddingSuccess(new BidPrice(mNativeAd.getAdControllerProxy().getECPM() + ""));
                }
                callLoadSuccess(Collections.singletonList(mWMNativeAdData));
            }

            @Override
            public void onAdExposure() {
                if (mWMNativeAdData != null) {
                    callNativeAdShow(mWMNativeAdData);
                }
            }

            @Override
            public void onAdExposureFailed(int i, String s) {

            }

            @Override
            public void onAdClicked() {
                if (mWMNativeAdData != null) {
                    callNativeAdClick(mWMNativeAdData);
                }
            }

            @Override
            public void onAdSkipped() {

            }

            @Override
            public void onAdClosed() {
                if (mWMNativeAdData != null && mWMNativeAdData instanceof AdvistaNativeAdData){
                    ((AdvistaNativeAdData) mWMNativeAdData).callClose();
                }
            }
        });
    }

    private void loadSelfRenderAd(Context context, String codeId) {
        AdLoadParams params = new AdLoadParams.Builder()
                .setSposId(codeId)
                .setMute(true)
                .setLoadTimeOut(5000)
                .build();
        AdvistaSdk.getInstance().loadSelfRenderNativeAd((Activity) context, params, new NativeAdListener() {
            @Override
            public void onNativeFeedAdLoaded(NativeFeedsData nativeFeedsData) {
                if (nativeFeedsData != null) {
                    isReady = true;
                    mNativeFeedsData = nativeFeedsData;
                    mWMNativeAdData = new AdvistaSelfRenderNativeData(nativeFeedsData);
                    if (getBiddingType() == WMConstants.AD_TYPE_CLIENT_BIDING) {
                        callLoadBiddingSuccess(new BidPrice(nativeFeedsData.getECPM() + ""));
                    }
                    callLoadSuccess(Collections.singletonList(mWMNativeAdData));
                }
            }

            @Override
            public void onLoadError(int code, String msg) {
                callLoadFail(new WMAdapterError(code, msg));
            }
        });
    }


    @Override
    public void onDestroy(Activity activity) {
        super.onDestroy(activity);
    }
}
