package com.jiaads.jiaadsapp.tobid;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.util.Log;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;
import com.windmill.sdk.WMConstants;
import com.windmill.sdk.WindMillError;
import com.windmill.sdk.base.WMAdapterError;
import com.windmill.sdk.custom.WMCustomInterstitialAdapter;
import com.windmill.sdk.models.BidPrice;
import java.util.HashMap;
import java.util.Map;

public class AdvistaCustomerInterstitialAdapter extends WMCustomInterstitialAdapter implements AdListener {
    private static final String TAG = "AdvistaCustomerInterstitialAdapter";

    private TemplateAd mInterstitialAd;
    private boolean isReady = false;

    @SuppressLint("LongLogTag")
    @Override
    public void loadAd(Activity activity, Map<String, Object> localExtra, Map<String, Object> serverExtra) {
        try {
            if (activity == null) {
                callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), "activity is null"));
                return;
            }
            isReady = false;

            String codeId = (String) serverExtra.get(WMConstants.PLACEMENT_ID);

            Log.d(TAG, "loadAd:" + codeId);

            AdLoadParams params = new AdLoadParams.Builder()
                    .setSposId(codeId)
                    .setMute(true)
                    .setShakeButton(true)
                    .setLoadTimeOut(5000)
                    .build();
            AdvistaSdk.getInstance().loadInterstitialAd(activity, params, this);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showAd(Activity activity, HashMap<String, String> localExtra, Map<String, Object> serverExtra) {
        try {
            if (mInterstitialAd != null && isReady) {
                mInterstitialAd.getAdControllerProxy().showAd();
            }
        } catch (Exception e) {
            callVideoAdPlayError(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_PLAY.getErrorCode(), "catch TT presentVideoAd error " + e.getMessage()));
        }
    }

    @Override
    public boolean isReady() {
        return isReady;
    }

    @Override
    public void destroyAd() {
        if (mInterstitialAd != null) {
            mInterstitialAd.getAdControllerProxy().destroyAd();
            mInterstitialAd = null;
        }
    }

    @Override
    public void onLoadError(int code, String msg) {
        callLoadFail(new WMAdapterError(code, msg));
    }

    @Override
    public void onShowError(int code, String msg) {
        callVideoAdPlayError(new WMAdapterError(code, msg));
    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        if (templateAd == null) {
            callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), "Advista interstitialAd is null"));
            return;
        }
        mInterstitialAd = templateAd;
    }

    @Override
    public void onResourceReady() {
        isReady = true;
        if (getBiddingType() == WMConstants.AD_TYPE_CLIENT_BIDING) {
            String eCpm = mInterstitialAd.getAdControllerProxy().getECPM() + "";
            callLoadBiddingSuccess(new BidPrice(eCpm));
        }
        callLoadSuccess();
    }

    @Override
    public void onAdExposure() {
        callVideoAdShow();
    }

    @Override
    public void onAdExposureFailed(int code, String msg) {

    }

    @Override
    public void onAdClicked() {
        callVideoAdClick();
    }

    @Override
    public void onAdSkipped() {
        callVideoAdSkipped();
    }

    @Override
    public void onAdClosed() {
        callVideoAdClosed();
    }
}
