package com.jiaads.jiaadsapp.tobid;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.jiaads.advista.sdk.AdvistaSdk;
import com.jiaads.advista.sdk.InitListener;
import com.windmill.sdk.WMConstants;
import com.windmill.sdk.WindMillError;
import com.windmill.sdk.custom.WMCustomAdapterProxy;
import org.json.JSONObject;
import java.util.Map;

public class AdvistaCustomerProxy extends WMCustomAdapterProxy {
    private static final String TAG = "AdvistaCustomerProxy";

    @Override
    public void initializeADN(Context context, Map<String, Object> serverExtra) {
        try {
            if (!(context.getApplicationContext() instanceof Application)){
                Log.e(TAG, "initializeADN: context must be instanceof Application");
                return;
            }
            String appCustomInfo = (String) serverExtra.get(WMConstants.CUSTOM_INFO);
            JSONObject object = new JSONObject(appCustomInfo);
            String appId = object.optString("appid");

            Log.d(TAG, "initializeADN:" + appId);

            AdvistaSdk.getInstance().init(appId, (Application) context.getApplicationContext(), new InitListener() {
                @Override
                public void onInitSuccess() {
                    callInitSuccess();
                }

                @Override
                public void onInitFailed(int code, String msg) {
                    Log.d(TAG, "fail:" + code + ":" + msg);
                    callInitFail(code, msg);
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
            callInitFail(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), e.getMessage());
        }
    }

    @Override
    public String getNetworkSdkVersion() {
        return AdvistaSdk.geVersion();
    }

    @Override
    public int baseOnToBidCustomAdapterVersion() {
        return WMConstants.TO_BID_CUSTOM_ADAPTER_VERSION_2;
    }

    @Override
    public void notifyPrivacyStatusChange() {

    }
}
