package com.jiaads.jiaadsapp.tobid;

import android.app.Activity;
import android.util.Log;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.RewardAdListener;
import com.jiaads.advista.mob.ad.listener.RewardInfo;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;
import com.windmill.sdk.WMConstants;
import com.windmill.sdk.WindMillError;
import com.windmill.sdk.base.WMAdapterError;
import com.windmill.sdk.custom.WMCustomRewardAdapter;
import com.windmill.sdk.models.BidPrice;
import java.util.HashMap;
import java.util.Map;

public class AdvistaCustomerRewardAdapter extends WMCustomRewardAdapter {

    private static final String TAG = "AdvistaCustomerReward";
    private TemplateAd mRewardAd;
    private boolean isReady = false;

    @Override
    public void loadAd(Activity activity, Map<String, Object> localExtra, Map<String, Object> serverExtra) {
        try {
            if (activity == null) {
                callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), "activity is null"));
                return;
            }

            isReady = false;

            String codeId = (String) serverExtra.get(WMConstants.PLACEMENT_ID);

            Log.d(TAG, "loadAd:" + codeId);

            AdLoadParams params = new AdLoadParams.Builder()
                    .setSposId(codeId)
                    .setMute(true)
                    .setShakeButton(true)
                    .setLoadTimeOut(5000)
                    .build();
            AdvistaSdk.getInstance().loadRewardVideoAd(activity, params, new RewardAdListener() {
                @Override
                public void onRewardVerify(RewardInfo rewardInfo) {
                    callVideoAdReward(rewardInfo.isRewardValid());
                }

                @Override
                public void onLoadError(int code, String msg) {
                    callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), "load error " + msg));
                }

                @Override
                public void onShowError(int i, String s) {

                }

                @Override
                public void onAdLoaded(TemplateAd templateAd) {
                    if (templateAd != null){
                        mRewardAd = templateAd;
                    }
                }

                @Override
                public void onResourceReady() {
                    isReady = true;
                    if (getBiddingType() == WMConstants.AD_TYPE_CLIENT_BIDING){
                        callLoadBiddingSuccess(new BidPrice(mRewardAd.getAdControllerProxy().getECPM() + ""));
                    }
                    callLoadSuccess();
                }

                @Override
                public void onAdExposure() {
                    callVideoAdShow();
                }

                @Override
                public void onAdExposureFailed(int i, String s) {

                }

                @Override
                public void onAdClicked() {
                    callVideoAdClick();
                }

                @Override
                public void onAdSkipped() {
                    callVideoAdSkipped();
                }

                @Override
                public void onAdClosed() {
                    callVideoAdClosed();
                }
            });

        }catch (Exception e){
            callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), e.getMessage()));
        }
    }

    @Override
    public void showAd(Activity activity, HashMap<String, String> localExtra, Map<String, Object> serverExtra) {
        try {
            if (mRewardAd != null && isReady) {
                mRewardAd.getAdControllerProxy().showAd();
            }
        } catch (Exception e) {
            callVideoAdPlayError(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_PLAY.getErrorCode(), "catch TT presentVideoAd error " + e.getMessage()));
        }
    }

    @Override
    public boolean isReady() {
        return isReady;
    }

    @Override
    public void destroyAd() {
        if (mRewardAd != null){
            mRewardAd.getAdControllerProxy().destroyAd();
        }
    }
}
