package com.jiaads.jiaadsapp.tobid;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.util.Log;
import android.view.ViewGroup;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.jiaads.advista.mob.ad.listener.AdListener;
import com.jiaads.advista.sdk.AdLoadParams;
import com.jiaads.advista.sdk.AdvistaSdk;
import com.windmill.sdk.WMConstants;
import com.windmill.sdk.WindMillError;
import com.windmill.sdk.base.WMAdapterError;
import com.windmill.sdk.custom.WMCustomSplashAdapter;
import com.windmill.sdk.models.BidPrice;
import java.util.Map;

public class AdvistaCustomerSplashAdapter extends WMCustomSplashAdapter implements AdListener {

    private static final String TAG = "AdvistaCustomerSplashAdapter";

    private TemplateAd mSplashAd;
    private boolean isReady = false;

    @SuppressLint("LongLogTag")
    @Override
    public void loadAd(Activity activity, ViewGroup viewGroup, Map<String, Object> localExtra, Map<String, Object> serverExtra) {
        try {
            if (activity == null) {
                callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), "activity is null"));
            } else {
                isReady = false;

                String codeId = (String) serverExtra.get(WMConstants.PLACEMENT_ID);

                Log.d(TAG, "loadAd SplashAd: " + codeId);

                AdLoadParams params = new AdLoadParams.Builder()
                        .setSposId(codeId)
                        .setMute(true)
                        .setShakeButton(true)
                        .setLoadTimeOut(3000)
                        .build();
                AdvistaSdk.getInstance().loadSplashAd(activity, params, this);


            }
        } catch (Exception e) {
            e.printStackTrace();
            callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), e.getMessage()));
        }
    }

    @Override
    public void showAd(Activity activity, ViewGroup viewGroup, Map<String, Object> serverExtra) {
        try {
            if (mSplashAd != null) {
                mSplashAd.getAdControllerProxy().showAd(viewGroup);
            }
        } catch (Exception e) {
            callSplashAdShowError(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_PLAY.getErrorCode(), e.getMessage()));
        }
    }

    @Override
    public boolean isReady() {
        return isReady;
    }

    @Override
    public void destroyAd() {
        if (mSplashAd != null) {
            mSplashAd.getAdControllerProxy().destroyAd();
            mSplashAd = null;
        }
    }


    @Override
    public void onLoadError(int code, String msg) {
        callLoadFail(new WMAdapterError(code, msg));
    }

    @Override
    public void onShowError(int code, String msg) {
        callSplashAdShowError(new WMAdapterError(code, msg));
    }

    @Override
    public void onAdLoaded(TemplateAd templateAd) {
        if (templateAd == null) {
            callLoadFail(new WMAdapterError(WindMillError.ERROR_AD_ADAPTER_LOAD.getErrorCode(), "Advista splashAd is null"));
            return;
        }
        mSplashAd = templateAd;
        isReady = true;

        if (getBiddingType() == WMConstants.AD_TYPE_CLIENT_BIDING) {
            String eCpm = mSplashAd.getAdControllerProxy().getECPM() + "";
            callLoadBiddingSuccess(new BidPrice(eCpm));
        }

        callLoadSuccess();
    }

    @Override
    public void onResourceReady() {

    }

    @Override
    public void onAdExposure() {
        callSplashAdShow();
    }

    @Override
    public void onAdExposureFailed(int i, String s) {

    }

    @Override
    public void onAdClicked() {
        callSplashAdSkipped();
    }

    @Override
    public void onAdSkipped() {
        callSplashAdSkipped();
    }

    @Override
    public void onAdClosed() {
        callSplashAdClosed();
    }
}
