package com.jiaads.jiaadsapp.tobid;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.jiaads.advista.mob.ad.TemplateAd;
import com.windmill.sdk.WMConstants;
import com.windmill.sdk.natives.WMImage;
import com.windmill.sdk.natives.WMNativeAdContainer;
import com.windmill.sdk.natives.WMNativeAdData;
import com.windmill.sdk.natives.WMNativeAdRender;
import java.util.Collections;
import java.util.List;

public class AdvistaNativeAdData extends WMNativeAdData {

    private TemplateAd mNativeAd;
    private NativeAdInteractionListener nativeAdInteractionListener;
    private DislikeInteractionCallback dislikeInteractionCallback;
    public AdvistaNativeAdData(TemplateAd templateAd) {
        this.mNativeAd = templateAd;
    }
    @Override
    public int getInteractionType() {
        return WMConstants.INTERACTION_TYPE_BROWSER;
    }

    @Override
    public int getAdPatternType() {
        return 0;
    }

    @Override
    public View getExpressAdView() {
        if (mNativeAd != null){
            return mNativeAd.getAdControllerProxy().getAdView();
        }
        return null;
    }

    @Override
    public void render() {

    }

    @Override
    public boolean isExpressAd() {
        return true;
    }

    @Override
    public boolean isNativeDrawAd() {
        return false;
    }

    @Override
    public String getCTAText() {
        return "";
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getDesc() {
        return "";
    }

    @Override
    public Bitmap getAdLogo() {
        return null;
    }

    @Override
    public String getIconUrl() {
        return "";
    }

    @Override
    public int getNetworkId() {
        return 0;
    }

    @Override
    public void connectAdToView(Activity activity, WMNativeAdContainer adContainer, WMNativeAdRender adRender) {

    }

    @Override
    public void bindImageViews(Context context, List<ImageView> imageViews, int defaultImageRes) {

    }

    @Override
    public List<String> getImageUrlList() {
        return Collections.emptyList();
    }

    @Override
    public List<WMImage> getImageList() {
        return Collections.emptyList();
    }

    @Override
    public void bindViewForInteraction(Context context, View view, List<View> clickableViews, List<View> creativeViewList, View disLikeView) {

    }

    @Override
    public void setInteractionListener(NativeAdInteractionListener adInteractionListener) {
        this.nativeAdInteractionListener = adInteractionListener;
    }

    @Override
    public void bindMediaView(Context context, ViewGroup mediaLayout) {

    }

    @Override
    public void setMediaListener(NativeADMediaListener nativeADMediaListener) {

    }

    @Override
    public void setDislikeInteractionCallback(Activity activity, DislikeInteractionCallback dislikeInteractionCallback) {
        this.dislikeInteractionCallback = dislikeInteractionCallback;
    }

    @Override
    public void setDownloadListener(AppDownloadListener appDownloadListener) {

    }

    @Override
    public void destroy() {

    }

    public void callClose(){
        if (dislikeInteractionCallback != null){
            dislikeInteractionCallback.onSelected(0,"0",true);
        }
    }
}
