package com.jiaads.jiaadsapp.tobid;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.czhj.sdk.common.utils.ImageManager;
import com.jiaads.advista.mob.ad.self.NativeAdEventListener;
import com.jiaads.advista.mob.ad.self.NativeFeedsData;
import com.jiaads.advista.mob.ad.self.NativeVideoViewListener;
import com.windmill.sdk.WMConstants;
import com.windmill.sdk.WindMillError;
import com.windmill.sdk.natives.WMImage;
import com.windmill.sdk.natives.WMNativeAdContainer;
import com.windmill.sdk.natives.WMNativeAdData;
import com.windmill.sdk.natives.WMNativeAdDataType;
import com.windmill.sdk.natives.WMNativeAdRender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AdvistaSelfRenderNativeData extends WMNativeAdData {

    public NativeFeedsData nativeFeedsData;
    private NativeAdInteractionListener nativeAdInteractionListener;

    public AdvistaSelfRenderNativeData(NativeFeedsData nativeFeedsData) {
        this.nativeFeedsData = nativeFeedsData;
    }

    @Override
    public int getInteractionType() {
        return WMConstants.INTERACTION_TYPE_BROWSER;
    }

    @Override
    public int getAdPatternType() {
        if (nativeFeedsData != null) {
            return nativeFeedsData.getMaterialType() == 0 ? WMNativeAdDataType.NATIVE_BIG_IMAGE_AD : WMNativeAdDataType.NATIVE_VIDEO_AD;
        }
        return 0;
    }

    @Override
    public View getExpressAdView() {
        return null;
    }

    @Override
    public void render() {

    }

    @Override
    public boolean isExpressAd() {
        return false;
    }

    @Override
    public boolean isNativeDrawAd() {
        return false;
    }

    @Override
    public String getCTAText() {
        if (nativeFeedsData != null) {
            return nativeFeedsData.getCtaText();
        }
        return "";
    }

    @Override
    public String getTitle() {
        if (nativeFeedsData != null) {
            return nativeFeedsData.getTitle();
        }
        return "";
    }

    @Override
    public String getDesc() {
        if (nativeFeedsData != null) {
            return nativeFeedsData.getDesc();
        }
        return "";
    }

    @Override
    public Bitmap getAdLogo() {
        if (nativeFeedsData != null) {
            return nativeFeedsData.getAdsLogoBitmap();
        }
        return null;
    }

    @Override
    public String getIconUrl() {
        if (nativeFeedsData != null) {
            return nativeFeedsData.getIconUrl();
        }
        return "";
    }

    @Override
    public int getNetworkId() {
        return 0;
    }

    @Override
    public void connectAdToView(Activity activity, WMNativeAdContainer adContainer, WMNativeAdRender adRender) {

    }

    @Override
    public void bindImageViews(Context context, List<ImageView> imageViews, int defaultImageRes) {
        try {
            if (imageViews != null && !imageViews.isEmpty()) {
                ImageManager.with(context).load(nativeFeedsData.getImageUrl()).into(imageViews.get(0));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getImageUrlList() {
        return Collections.singletonList(nativeFeedsData.getImageUrl());
    }

    ;

    @Override
    public List<WMImage> getImageList() {
        WMImage image = new WMImage() {
            @Override
            public int getHeight() {
                if (nativeFeedsData != null) {
                    return nativeFeedsData.getMainImageHeight();
                }
                return 0;
            }

            @Override
            public int getWidth() {
                if (nativeFeedsData != null) {
                    return nativeFeedsData.getMainImageWidth();
                }
                return 0;
            }

            @Override
            public String getImageUrl() {
                if (nativeFeedsData != null) {
                    return nativeFeedsData.getImageUrl();
                }
                return "";
            }

            @Override
            public boolean isValid() {
                if (nativeFeedsData != null) {
                    return !TextUtils.isEmpty(nativeFeedsData.getImageUrl());
                }
                return false;
            }
        };
        return Collections.singletonList(image);
    }

    @Override
    public void bindViewForInteraction(Context context, View view, List<View> clickableViews, List<View> creativeViewList, View disLikeView) {
        if (nativeFeedsData != null) {
            nativeFeedsData.registerSelfRenderViews((Activity) context, view, (ArrayList<View>) clickableViews, new NativeAdEventListener() {
                @Override
                public void onAdExposure() {
                    if (nativeAdInteractionListener != null) {
                        nativeAdInteractionListener.onADExposed(null);
                    }
                }

                @Override
                public void onAdExposureFailed(int i, String s) {
                    if (nativeAdInteractionListener != null) {
                        nativeAdInteractionListener.onADError(null, WindMillError.ERROR_AD_ADAPTER_PLAY);
                    }
                }

                @Override
                public void onAdClicked() {
                    if (nativeAdInteractionListener != null) {
                        nativeAdInteractionListener.onADClicked(null);
                    }
                }
            });
        }
    }

    @Override
    public void setInteractionListener(NativeAdInteractionListener adInteractionListener) {
        this.nativeAdInteractionListener = adInteractionListener;
    }

    @Override
    public void bindMediaView(Context context, ViewGroup mediaLayout) {
        if (nativeFeedsData != null && nativeFeedsData.getMaterialType() == 1) {
            if (mediaLayout != null && nativeFeedsData.getNmApAdVideo() != null) {
                mediaLayout.removeAllViews();
                if (nativeFeedsData.getNmApAdVideo().getParent() != null){
                    ((ViewGroup) nativeFeedsData.getNmApAdVideo().getParent()).removeView(nativeFeedsData.getNmApAdVideo());
                }
                mediaLayout.addView(nativeFeedsData.getNmApAdVideo());
            }
        }
    }

    @Override
    public void setMediaListener(NativeADMediaListener nativeADMediaListener) {
        if (nativeFeedsData != null) {
            nativeFeedsData.getNmApAdVideo().setVideoViewListener(new NativeVideoViewListener() {
                @Override
                public void onVideoLoading() {

                }

                @Override
                public void onVideoReady() {
                    if (nativeADMediaListener != null) {
                        nativeADMediaListener.onVideoLoad();
                    }
                }

                @Override
                public void onVideoStart() {
                    if (nativeADMediaListener != null) {
                        nativeADMediaListener.onVideoStart();
                    }
                }

                @Override
                public void onVideoProgress(double v) {

                }

                @Override
                public void onVideoPause() {
                    if (nativeADMediaListener != null) {
                        nativeADMediaListener.onVideoPause();
                    }
                }

                @Override
                public void onVideoResume() {
                    if (nativeADMediaListener != null) {
                        nativeADMediaListener.onVideoResume();
                    }
                }

                @Override
                public void onVideoCompleted() {
                    if (nativeADMediaListener != null) {
                        nativeADMediaListener.onVideoCompleted();
                    }
                }

                @Override
                public void onVideoStop() {

                }

                @Override
                public void onVideoError(int code) {
                    if (nativeADMediaListener != null) {
                        nativeADMediaListener.onVideoError(WindMillError.getWindAdError(code));
                    }
                }
            });
        }
    }

    @Override
    public void setDislikeInteractionCallback(Activity activity, DislikeInteractionCallback dislikeInteractionCallback) {

    }

    @Override
    public void setDownloadListener(AppDownloadListener appDownloadListener) {

    }

    @Override
    public void destroy() {
        if (nativeFeedsData != null) {
            nativeFeedsData.destroy();
        }
    }
}
